print(version)
#install.packages("e1071")
#install.packages("caTools")
#install.packages("caret")
#install.packages("ggpubr")
#install.packages("kdensity")
#install.packages("psych")
library(reshape2)
library(e1071)
library(caTools)
library(caret)
library(ggpubr)
library(dplyr)
library(ggplot2)
library(psych)
library(MASS)
library("kdensity")

data=iris
print("Shape of data")
print(dim(data))



kde = kdensity(data$Sepal.Length, start = "gumbel", kernel = "gaussian")
plot(kde)


pairs.panels(data, hist.col="white", scale=TRUE)

melted_cormat <- melt(cor(data[1:4]))
head(melted_cormat)

ggplot(data = melted_cormat, aes(x=Var1,y=Var2, fill = value)) +
geom_tile()


split <- sample.split(data, SplitRatio = 0.8)
train <- subset(data, split == "TRUE")
test <- subset(data, split == "FALSE")
print('Shape of Train')
print(dim(train))
print('Shape of Test')
print(dim(test))


train_scale <- scale(train[,1:4])
test_scale <- scale(test[,1:4])


set.seed(100) 
nbmodel <- naiveBayes(x=train_scale,y=train$Species,usekernel=T)
print(nbmodel)

y_pred  <- predict(nbmodel, test_scale)
print(y_pred)

cm <- table(test$Species, y_pred)
print(cm)

print(confusionMatrix(cm))